// 顶部图片横幅广告 - 纯JS封装版
(function() {
    // ********** 可自定义配置（修改此处即可，无需动其他代码）**********
    const CONFIG = {
        adHeight: '120px', // 广告高度
        adLink: 'https://your-ad-link.com', // 广告跳转链接
        adImg: 'https://s1.hdslb.com/bfs/static/game-web/duang/ranks/asserts/ranks.ea2809d.jpg', // 广告图片地址（建议1920*120px）
        adAlt: '顶部横幅广告', // 图片替代文本
        zIndex: 9999, // 广告层级（防止被遮挡）
        transitionTime: '0.3s' // 平滑过渡时间（单位s）
    };

    // 1. 初始化页面body样式：预留广告高度，添加过渡
    const body = document.body;
    body.style.paddingTop = CONFIG.adHeight;
    body.style.transition = `padding-top ${CONFIG.transitionTime} ease`;
    // 防止body默认边距影响，重置margin
    if (!body.style.margin) body.style.margin = '0';

    // 2. 创建广告容器并设置核心样式
    const adBanner = document.createElement('div');
    adBanner.style.cssText = `
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: ${CONFIG.adHeight};
        z-index: ${CONFIG.zIndex};
        overflow: hidden;
        border-bottom: 1px solid #eee;
        transition: all ${CONFIG.transitionTime} ease;
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    `;

    // 3. 构建广告内部结构（链接+图片+关闭按钮）
    adBanner.innerHTML = `
        <a href="${CONFIG.adLink}" target="_blank" style="
            display: block;
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
        ">
            <img src="${CONFIG.adImg}" alt="${CONFIG.adAlt}" style="
                width: 100%;
                height: 100%;
                object-fit: cover;
                border: none;
                outline: none;
            ">
        </a>
        <button id="closeAdBanner" style="
            position: absolute;
            top: 10px;
            right: 20px;
            width: 30px;
            height: 30px;
            border: none;
            background: rgba(0,0,0,0.5);
            color: #ffffff;
            font-size: 16px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: ${CONFIG.zIndex + 1};
            padding: 0;
            margin: 0;
            transition: background ${CONFIG.transitionTime} ease;
        ">×</button>
    `;

    // 4. 将广告容器添加到页面body最顶部
    document.body.appendChild(adBanner);

    // 5. 绑定关闭按钮事件：平滑隐藏广告，恢复页面布局
    const closeBtn = document.getElementById('closeAdBanner');
    // 按钮悬浮效果优化
    closeBtn.addEventListener('mouseover', () => {
        closeBtn.style.background = 'rgba(0,0,0,0.8)';
    });
    closeBtn.addEventListener('mouseout', () => {
        closeBtn.style.background = 'rgba(0,0,0,0.5)';
    });
    // 关闭核心逻辑
    closeBtn.addEventListener('click', () => {
        adBanner.style.opacity = '0'; // 先透明（平滑过渡）
        // 过渡完成后隐藏容器，避免占用点击区域
        setTimeout(() => {
            adBanner.style.display = 'none';
        }, parseFloat(CONFIG.transitionTime) * 1000);
        // 恢复body顶部边距，页面布局归位
        body.style.paddingTop = '0';
    });
})();